<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ext_campaign_conversions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('campaign_id')->constrained('ext_marketing_campaigns')->onDelete('cascade');
            $table->foreignId('shopify_order_id')->constrained('ext_shopify_orders')->onDelete('cascade');
            $table->decimal('revenue', 10, 2)->default(0);
            $table->string('utm_source')->nullable();
            $table->string('utm_medium')->nullable();
            $table->string('utm_campaign')->nullable();
            $table->string('utm_term')->nullable();
            $table->string('utm_content')->nullable();
            $table->string('conversion_type')->default('direct'); // direct, assisted, last_click
            $table->timestamp('converted_at')->nullable();
            $table->timestamps();
            
            $table->index('campaign_id');
            $table->index('shopify_order_id');
            $table->index('utm_campaign');
            $table->index('converted_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ext_campaign_conversions');
    }
};
